/********************************************************************
 * TINYMCE PAGEBUILDER — MUSS GENAU SO AUSSEHEN
 ********************************************************************/

// --------------------------------------------------------------
// *** ZEILE 1–10 ***
// WordPress MediaFrame vorbereiten (für Bild-Uploads)
// --------------------------------------------------------------
if (typeof wp !== 'undefined' && wp.media && !window.pb_media_frame) {
    window.pb_media_frame = wp.media({
        title: 'Bild auswählen',
        multiple: false
    });
}

(function() {

    tinymce.create('tinymce.plugins.html_pagebuilder', {

        init: function(ed, url) {

            // ----------------------------------------------------------
            // BUTTON (mit Layer)
            // ----------------------------------------------------------
            ed.addButton('pb_button', {
                title: 'Button',
                icon: 'newdocument',
                onclick: function() {

                    ed.windowManager.open({
                        title: 'Button erstellen',
                        body: [
                            {type:'textbox', name:'text', label:'Text'},
                            {type:'textbox', name:'url',  label:'URL'}
                        ],
                        onsubmit: function(e) {
                            ed.insertContent(
                                '<a href="' + e.data.url + '" class="pb-btn">' +
                                e.data.text +
                                '</a>'
                            );
                        }
                    });

                }
            });

            // ----------------------------------------------------------
            // BOX (mit Layer)
            // ----------------------------------------------------------
            ed.addButton('pb_box', {
                title: 'Box',
                icon: 'insertdatetime',
                onclick: function() {

                    ed.windowManager.open({
                        title: 'Box Inhalt',
                        body: [
                            {type:'textbox', name:'content', label:'Inhalt',
                             multiline:true, minWidth:300, minHeight:100}
                        ],
                        onsubmit: function(e) {
                            ed.insertContent(
                                '<div class="pb-box">' + e.data.content + '</div>'
                            );
                        }
                    });

                }
            });

            // ----------------------------------------------------------
            // SPALTEN (mit Layer)
            // ----------------------------------------------------------
            ed.addButton('pb_columns', {
                title: 'Spalten',
                icon: 'table',
                onclick: function() {

                    ed.windowManager.open({
                        title: 'Spalten',
                        body: [
                            {
                                type:'listbox',
                                name:'cols',
                                label:'Anzahl',
                                values:[
                                    {text:'2 Spalten', value:'2'},
                                    {text:'3 Spalten', value:'3'}
                                ]
                            },
                            {type:'textbox', name:'col1', label:'Spalte 1', multiline:true},
                            {type:'textbox', name:'col2', label:'Spalte 2', multiline:true},
                            {type:'textbox', name:'col3', label:'Spalte 3 (nur für 3)', multiline:true}
                        ],
                        onsubmit: function(e) {

                            let html = '<div class="pb-row">';
                            html += '<div class="pb-col">' + e.data.col1 + '</div>';
                            html += '<div class="pb-col">' + e.data.col2 + '</div>';

                            if (e.data.cols === "3") {
                                html += '<div class="pb-col">' + e.data.col3 + '</div>';
                            }

                            html += '</div>';

                            ed.insertContent(html);
                        }
                    });

                }
            });

            // ----------------------------------------------------------
            // BILD (mit Mediathek Layer)
            // ----------------------------------------------------------
            ed.addButton('pb_image', {
                title: 'Bild',
                icon: 'image',
                onclick: function() {

                    window.pb_media_frame.open();

                    window.pb_media_frame.off('select');
                    window.pb_media_frame.on('select', function() {
                        let a = window.pb_media_frame.state().get('selection').first().toJSON();

                        ed.insertContent(
                            '<img src="' + a.url + '" class="pb-img" alt="">'
                        );
                    });

                }
            });

            // ----------------------------------------------------------
            // CARD (mit Layer + Mediathek)
            // ----------------------------------------------------------
            ed.addButton('pb_card', {
                title: 'Card',
                icon: 'insertdatetime',
                onclick: function() {

                    ed.windowManager.open({
                        title: 'Card erstellen',
                        body: [
                            {type:'textbox', name:'title', label:'Titel'},
                            {type:'textbox', name:'text',  label:'Text', multiline:true},

                            // Bild wählen
                            {
                                type:'button',
                                name:'img_btn',
                                label:'Bild',
                                text:'Bild auswählen',
                                onclick:function(){
                                    window.pb_media_frame.open();

                                    window.pb_media_frame.off('select');
                                    window.pb_media_frame.on('select', function() {
										let a = window.pb_media_frame.state().get('selection').first().toJSON();
										tinymce.activeEditor.windowManager.getWindows()[0]
											.find('[name=img]')[0]
											.value(a.url);
									});
                                }
                            },

                            {type:'textbox', name:'img', label:'Bild URL'}
                        ],
                        onsubmit: function(e) {

                            ed.insertContent(
                                '<div class="pb-card">' +
                                    '<img src="' + e.data.img + '" class="pb-card-img">' +
                                    '<h3 class="pb-card-title">' + e.data.title + '</h3>' +
                                    '<div class="pb-card-text">' + e.data.text + '</div>' +
                                '</div>'
                            );
                        }
                    });

                }
            });

            // ----------------------------------------------------------
            // INFOBOX
            // ----------------------------------------------------------
            ed.addButton('pb_infobox', {
                title: 'Infobox',
                icon: 'info',
                onclick: function() {

                    ed.windowManager.open({
                        title: 'Infobox',
                        body: [
                            {type:'textbox', name:'content', label:'Text', multiline:true}
                        ],
                        onsubmit:function(e){
                            ed.insertContent(
                                '<div class="pb-infobox">' + e.data.content + '</div>'
                            );
                        }
                    });

                }
            });

            // ----------------------------------------------------------
            // CTA
            // ----------------------------------------------------------
            ed.addButton('pb_cta', {
                title: 'CTA',
                icon: 'newdocument',
                onclick: function() {

                    ed.windowManager.open({
                        title: 'CTA erstellen',
                        body: [
                            {type:'textbox', name:'title',   label:'Titel'},
                            {type:'textbox', name:'text',    label:'Text', multiline:true},
                            {type:'textbox', name:'btntext', label:'Button-Text'},
                            {type:'textbox', name:'btnurl',  label:'Button-URL'}
                        ],
                        onsubmit: function(e) {

                            ed.insertContent(
                                '<div class="pb-cta">' +
                                    '<h2>' + e.data.title + '</h2>' +
                                    '<p>' + e.data.text + '</p>' +
                                    '<a href="' + e.data.btnurl + '" class="pb-btn">' + e.data.btntext + '</a>' +
                                '</div>'
                            );

                        }
                    });

                }
            });

            // ----------------------------------------------------------
            // GRID 3
            // ----------------------------------------------------------
            ed.addButton('pb_grid3', {
                title: '3er Grid',
                icon: 'table',
                onclick: function() {

                    ed.windowManager.open({
                        title: '3er Grid',
                        body: [
                            {type:'textbox', name:'i1', label:'Item 1', multiline:true},
                            {type:'textbox', name:'i2', label:'Item 2', multiline:true},
                            {type:'textbox', name:'i3', label:'Item 3', multiline:true}
                        ],
                        onsubmit:function(e){
                            ed.insertContent(
                                '<div class="pb-grid-3">' +
                                    '<div class="pb-grid-item">' + e.data.i1 + '</div>' +
                                    '<div class="pb-grid-item">' + e.data.i2 + '</div>' +
                                    '<div class="pb-grid-item">' + e.data.i3 + '</div>' +
                                '</div>'
                            );
                        }
                    });

                }
            });

            // ----------------------------------------------------------
            // HERO (mit Mediathek)
            // ----------------------------------------------------------
            ed.addButton('pb_hero', {
                title: 'Hero',
                icon: 'fullscreen',
                onclick: function() {

                    ed.windowManager.open({
                        title: 'Hero erstellen',
                        body: [
                            {type:'textbox', name:'title', label:'Titel'},
                            {type:'textbox', name:'text',  label:'Untertitel'},

                            // BG wählen
                            {
                                type:'button',
                                name:'bg_btn',
                                label:'Hintergrund',
                                text:'Bild auswählen',
                                onclick:function(){
                                    window.pb_media_frame.open();

                                    window.pb_media_frame.off('select');
                                    window.pb_media_frame.on('select', function() {
										let a = window.pb_media_frame.state().get('selection').first().toJSON();
										tinymce.activeEditor.windowManager.getWindows()[0]
											.find('[name=bg]')[0]
											.value(a.url);
									});
                                }
                            },

                            {type:'textbox', name:'bg', label:'BG URL'}
                        ],
                        onsubmit:function(e){

                            ed.insertContent(
                                '<div class="pb-hero" style="background:url(' + e.data.bg + ') center/cover;">' +
                                    '<h1 class="pb-hero-title">' + e.data.title + '</h1>' +
                                    '<p class="pb-hero-text">' + e.data.text + '</p>' +
                                '</div>'
                            );

                        }
                    });

                }
            });

            // ----------------------------------------------------------
            // ACCORDION
            // ----------------------------------------------------------
            ed.addButton('pb_accordion', {
                title: 'Accordion',
                icon: 'indent',
                onclick: function() {

                    ed.windowManager.open({
                        title: 'Accordion',
                        body: [
                            {type:'textbox', name:'q1', label:'Frage 1'},
                            {type:'textbox', name:'a1', label:'Antwort 1', multiline:true},
                            {type:'textbox', name:'q2', label:'Frage 2'},
                            {type:'textbox', name:'a2', label:'Antwort 2', multiline:true}
                        ],
                        onsubmit:function(e){
                            ed.insertContent(
                                '<div class="pb-accordion">' +
                                    '<div class="pb-acc-item"><div class="pb-acc-title">' + e.data.q1 + '</div><div class="pb-acc-content">' + e.data.a1 + '</div></div>' +
                                    '<div class="pb-acc-item"><div class="pb-acc-title">' + e.data.q2 + '</div><div class="pb-acc-content">' + e.data.a2 + '</div></div>' +
                                '</div>'
                            );
                        }
                    });

                }
            });

            // ----------------------------------------------------------
            // TABS
            // ----------------------------------------------------------
            ed.addButton('pb_tabs', {
                title: 'Tabs',
                icon: 'options',
                onclick: function() {

                    ed.windowManager.open({
                        title: 'Tabs erstellen',
                        body: [
                            {type:'textbox', name:'t1', label:'Tab 1 Titel'},
                            {type:'textbox', name:'c1', label:'Tab 1 Inhalt', multiline:true},
                            {type:'textbox', name:'t2', label:'Tab 2 Titel'},
                            {type:'textbox', name:'c2', label:'Tab 2 Inhalt', multiline:true}
                        ],
                        onsubmit:function(e){
                            ed.insertContent(
                                '<div class="pb-tabs">' +
                                    '<div class="pb-tab-buttons">' +
                                        '<button class="pb-tab-btn">' + e.data.t1 + '</button>' +
                                        '<button class="pb-tab-btn">' + e.data.t2 + '</button>' +
                                    '</div>' +
                                    '<div class="pb-tab-content">' + e.data.c1 + '</div>' +
                                    '<div class="pb-tab-content">' + e.data.c2 + '</div>' +
                                '</div>'
                            );
                        }
                    });

                }
            });

        } // END INIT
    });

    tinymce.PluginManager.add('html_pagebuilder', tinymce.plugins.html_pagebuilder);

})();